<?php
function of_options() {
	//Access the WordPress Categories via an Array
	$of_categories     = array();
	$of_categories_obj = get_categories( 'hide_empty=0' );
	foreach ( $of_categories_obj as $of_cat ) {
		$of_categories[ $of_cat->cat_ID ] = $of_cat->cat_name;
	}
	$categories_tmp = array_unshift( $of_categories, "Select a category:" );

	//Access the WordPress Pages via an Array
	$of_pages      = array();
	$of_pages_obj  = get_pages( 'sort_column=post_parent,menu_order' );
	$of_pages['0'] = __('Select a page:', "flatsome-child");
	foreach ( $of_pages_obj as $of_page ) {
		$of_pages[ $of_page->ID ] = $of_page->post_title;
	}

	// Set the Options Array
	global $of_options;
	$of_options = array();

	$url = ADMIN_DIR . 'assets/images/';

	$of_options[] = array(
		"name" => __("Global Settings", "flatsome-child"),
		"type" => "heading",
		"jsid"   => "global_settings",
		"std"  => "",
	);

	$of_options[] = array(
		"name" => __("Header Scripts", "flatsome-child"),
		"desc" => __("Add custom scripts inside HEAD tag. You need to have SCRIPT tag around the scripts.", "flatsome-child"),
		"id"   => "html_scripts_header",
		"std"  => "",
		"type" => "textarea"
	);

	$of_options[] = array(
		"name" => __("Footer Scripts", "flatsome-child"),
		"desc" => __("Here is the place to paste your Google Analytics code or any other JS code you might want to add to be loaded in the footer of your website.", "flatsome-child"),
		"id"   => "html_scripts_footer",
		"std"  => "",
		"type" => "textarea"
	);

	$of_options[] = array(
		"name" => __("Flatsome 2.0 Content Support", "flatsome-child"),
		"id"   => "flatsome_fallback",
		"desc" => __("Support content made in Flatsome 2.0. Disable to speed up site.", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Custom CSS", "flatsome-child"),
		"type" => "heading",
		"jsid"   => "Custom CSS",
	);

	$of_options[] = array(
		"name" => __("All screens", "flatsome-child"),
		"desc" => __("Add custom CSS here", "flatsome-child"),
		"id"   => "html_custom_css",
		"std"  => "",
		"type" => "textarea"
	);

	$of_options[] = array(
		"name" => __("Tablets and down", "flatsome-child"),
		"desc" => __("Add custom CSS here for tablets and mobile", "flatsome-child"),
		"id"   => "html_custom_css_tablet",
		"std"  => "",
		"type" => "textarea"
	);

	$of_options[] = array(
		"name" => __("Mobile only", "flatsome-child"),
		"desc" => __("Add custom CSS here for mobile view", "flatsome-child"),
		"id"   => "html_custom_css_mobile",
		"std"  => "",
		"type" => "textarea"
	);

	$of_options[] = array(
		"name" => __("Site Loader", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Site Loader",

	);

	$of_options[] = array(
		"name"    => __("Site Loader", "flatsome-child"),
		"id"      => "site_loader",
		"desc"    => __("Enable Site Loader overlay when loading the site.", "flatsome-child"),
		"type"    => "select",
		"std"     => 0,
		"options" => array(
			0      => __("Disabled", "flatsome-child"),
			'home' => __("Enable on homepage", "flatsome-child"),
			'all'  => __("Enable on all pages", "flatsome-child")
		),
	);

	$of_options[] = array(
		"name"    => __("Color", "flatsome-child"),
		"id"      => "site_loader_color",
		"type"    => "select",
		"std"     => 'light',
		"options" => array(
			'light' => __("Light", "flatsome-child"),
			'dark'  => __("Dark", "flatsome-child")
		),
	);

	$of_options[] = array(
		"name" => __("Background Color", "flatsome-child"),
		"id"   => "site_loader_bg",
		"std"  => "",
		"type" => "color"
	);

	$of_options[] = array(
		"name" => __("Site Search", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Site Search",
	);

	$of_options[] = array(
		"name" => __("Live Search", "flatsome-child"),
		"id"   => "live_search",
		"desc" => __("Enable live search for products and pages.", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Search placeholder", "flatsome-child"),
		"desc" => __("Change the search field placeholder", "flatsome-child"),
		"id"   => "search_placeholder",
		"type" => "text"
	);

	if ( is_woocommerce_activated() ) {
		$of_options[] = array(
			"name" => __("Show Blog and pages in search results.", "flatsome-child"),
			"id"   => "search_result",
			"desc" => __("Enable blog and pages in search results", "flatsome-child"),
			"std"  => 1,
			"type" => "checkbox"
		);
		$of_options[] = array(
			"name" => __("Search SKU", "flatsome-child"),
			"desc" => __("Allow searching by SKU in live search.", "flatsome-child"),
			"id"   => "search_by_sku",
			"std"  => 0,
			"type" => "checkbox"
		);
	}

	// UX Builder
	$of_options[] = array(
		"name" => __("UX Builder", "flatsome-child"),
		"type" => "heading",
		"jsid" => "UX Builder",
	);

	$of_options[] = array(
		"name" => __("Flatsome Studio (BETA)", "flatsome-child"),
		"id"   => "flatsome_studio",
		"desc" => __("Enable access to Flatsome Studio Beta", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	// Lazy loading
	$of_options[] = array(
		"name" => __("Lazy Loading", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Lazy Loading",
	);

	$of_options[] = array(
		"name" => __("Lazy Load Google Fonts", "flatsome-child"),
		"id"   => "lazy_load_google_fonts",
		"desc" => __("Enable lazy loading of Google Fonts", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Lazy Load Icons", "flatsome-child"),
		"id"   => "lazy_load_icons",
		"desc" => __("Enable lazy loading of Flatsome interface icons", "flatsome-child"),
		"std"  => 0,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Lazy Load Banner and Section backgrounds", "flatsome-child"),
		"id"   => "lazy_load_backgrounds",
		"desc" => __("Enable lazy loading of banner and section backgrounds.", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Lazy Load Images", "flatsome-child"),
		"id"   => "lazy_load_images",
		"desc" => __("Enable lazy loading for images. <strong>Use with caution! Disable if you have plugin compability problems.</strong>", "flatsome-child"),
		"std"  => 0,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Google APIs", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Google APIs",
	);

	$of_options[] = array(
		"name" => __("Google Maps API", "flatsome-child"),
		"desc" => __("Enter Google Maps API key here to enable Maps. You can generate one here: <a target='_blank' href='https://developers.google.com/maps/documentation/javascript/'>Google Maps API</a>", "flatsome-child"),
		"id"   => "google_map_api",
		"std"  => "",
		"type" => "text"
	);

	$of_options[] = array(
		"name" => __("Maintenance Mode", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Maintenance Mode",
	);

	$of_options[] = array(
		"name" => __("Maintenance Mode", "flatsome-child"),
		"id"   => "maintenance_mode",
		"desc" => __("Enable Maintenance Mode for all users except admins.", "flatsome-child"),
		"std"  => 0,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name" => __("Admin Notice", "flatsome-child"),
		"id"   => "maintenance_mode_admin_notice",
		"desc" => __("Show admin notice when Maintenance Mode is enabled.", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	$of_options[] = array(
		"name"    => __("Custom Maintenance Page", "flatsome-child"),
		"id"      => "maintenance_mode_page",
		"desc"    => __("Set a custom page as maintenance page. Only this page will be visible for visitors.", "flatsome-child"),
		"std"     => 0,
		"type"    => "select",
		"options" => $of_pages
	);

	$of_options[] = array(
		"name" => __("Maintenance Mode Text", "flatsome-child"),
		"desc" => __("The text that will be visible to your customers when accessing maintenance screen.", "flatsome-child"),
		"id"   => "maintenance_mode_text",
		"std"  => "Please check back soon..",
		"type" => "text"
	);

	$of_options[] = array(
		"name" => __("Custom Fonts", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Custom Fonts",
	);

	$of_options[] = array(
		"name" => __("Add custom fonts", "flatsome-child"),
		"type" => "info",
		"desc" => __('<p style="font-size:16px">We are working on a new solution for adding custom fonts to Flatsome. Meanwhile follow this guide: <a href="//uxthemes.helpscoutdocs.com/article/224-add-custom-fonts-to-flatsome" target="_blank">Add Custom fonts to Flatsome</p></a>', "flatsome-child")
	);

	if ( is_woocommerce_activated() ) {

		$of_options[] = array(
			"name" => __("WooCommerce", "flatsome-child"),
			"type" => "heading",
			"jsid" => "WooCommerce",
		);

		$of_options[] = array(
			"name" => __("Disable Reviews Global", "flatsome-child"),
			"id"   => "disable_reviews",
			"desc" => __("Disable reviews globally.", "flatsome-child"),
			"std"  => 0,
			"type" => "checkbox"
		);

		$of_options[] = array(
			"name" => __("Shop header", "flatsome-child"),
			"desc" => __("Enter HTML that should be placed on top of main shop page. Shortcodes are allowed.", "flatsome-child"),
			"id"   => "html_shop_page",
			"std"  => "",
			"type" => "textarea"
		);

		$of_options[] = array(
			"name" => __("Additional Global tab/section title", "flatsome-child"),
			"id"   => "tab_title",
			"std"  => "",
			"type" => "text"
		);

		$of_options[] = array(
			"name" => __("Additional Global tab/section content", "flatsome-child"),
			"id"   => "tab_content",
			"std"  => "",
			"type" => "textarea",
			"desc" => __("Add additional tab content here... Like Size Charts etc.", "flatsome-child")
		);

		$of_options[] = array(
			"name" => __("HTML before Add To Cart button (Global)", "flatsome-child"),
			"desc" => __("Enter HTML and shortcodes that will show before Add to cart selections.", "flatsome-child"),
			"id"   => "html_before_add_to_cart",
			"std"  => " ",
			"type" => "textarea"
		);

		$of_options[] = array(
			"name" => __("HTML after Add To Cart button (Global)", "flatsome-child"),
			"desc" => __("Enter HTML and shortcodes that will show after Add to cart button.", "flatsome-child"),
			"id"   => "html_after_add_to_cart",
			"std"  => "",
			"type" => "textarea"
		);

		$of_options[] = array(
			"name" => __("Thank You Page Content / Scripts", "flatsome-child"),
			"desc" => __("Enter scripts or custom HTML content for the thank you page here", "flatsome-child"),
			"id"   => "html_thank_you",
			"std"  => "",
			"type" => "textarea"
		);

		$of_options[] = array(
			"name" => __("Catalog Mode", "flatsome-child"),
			"type" => "heading",
			"jsid" => "Catalog Mode",
		);

		$of_options[] = array(
			"name" => __("Enable catalog mode", "flatsome-child"),
			"id"   => "catalog_mode",
			"desc" => __("Enable catalog mode. This will disable Add To Cart buttons / Checkout and Shopping cart.", "flatsome-child"),
			"std"  => 0,
			"type" => "checkbox"
		);

		$of_options[] = array(
			"name" => __("Disable prices", "flatsome-child"),
			"id"   => "catalog_mode_prices",
			"desc" => __("Select to disable prices on category pages and product page.", "flatsome-child"),
			"std"  => 0,
			"type" => "checkbox"
		);

		$of_options[] = array(
			"name" => __("Cart / Account replacement (header)", "flatsome-child"),
			"id"   => "catalog_mode_header",
			"std"  => "",
			"type" => "textarea",
			"desc" => __("Enter content you want to display instead of Account / Cart. Shortcodes are allowed. For search box enter <b>[search]</b>. For social icons enter: <b>[follow twitter='http://' facebook='http://' email='post@email.com' pinterest='http://']</b>", "flatsome-child")
		);

		$of_options[] = array(
			"name" => __("Add to cart replacement - Product page", "flatsome-child"),
			"id"   => "catalog_mode_product",
			"std"  => "",
			"type" => "textarea",
			"desc" => __("Enter contact information or enquery form shortcode here.", "flatsome-child")
		);

		$of_options[] = array(
			"name" => __("Add to cart replacement - Product Quick View", "flatsome-child"),
			"id"   => "catalog_mode_lightbox",
			"std"  => "",
			"type" => "textarea",
			"desc" => __("Enter text that will show in product quick view", "flatsome-child")
		);
	}

	// Portfolio
	$of_options[] = array(
		"name" => __("Portfolio", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Portfolio",
	);

	$of_options[] = array(
		"name" => __("Enable Portfolio", "flatsome-child"),
		"id"   => "fl_portfolio",
		"desc" => __("Enable portfolio", "flatsome-child"),
		"std"  => 1,
		"type" => "checkbox"
	);

	// Integrations
	$of_options[] = array(
		"name" => __("Integrations", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Integrations",
	);

	$of_options[] = array(
		"name" => "",
		"type" => "info",
		"desc" => __('<p style="font-size:14px">Additional options for integrated plugins will be shown here if they are activated.</p>', "flatsome-child")
	);

	if ( function_exists( 'ubermenu' ) ) {
		$of_options[] = array(
			"name" => __("Ubermenu", "flatsome-child"),
			"id"   => "flatsome_uber_menu",
			"desc" => __("Enable full width UberMenu. You can also insert this elsewhere by using the UberMenu options.", "flatsome-child"),
			"std"  => 1,
			"type" => "checkbox"
		);
	}

	// Backup Options
	$of_options[] = array(
		"name" => __("Backup and Import", "flatsome-child"),
		"type" => "heading",
		"jsid" => "Backup and Import",
	);

	$of_options[] = array(
		"name" => __("Backup and Restore Options", "flatsome-child"),
		"id"   => "of_backup",
		"std"  => "",
		"type" => "backup",
		"desc" => __('You can use the two buttons below to backup your current options, and then restore it back at a later time. This is useful if you want to experiment on the options but would like to keep the old settings in case you need it back.', "flatsome-child"),
	);

	$of_options[] = array(
		"name" => __("Transfer Theme Options Data", "flatsome-child"),
		"id"   => "of_transfer",
		"std"  => "",
		"type" => "transfer",
		"desc" => __('You can transfer the saved options data between different installs by copying the text inside the text box. To import data from another install, replace the data in the text box with the one from another install and click "Import Options".', "flatsome-child"),
	);

} // End function: of_options()
