<?php
/**
 * Created by PhpStorm.
 * User: mojtaba
 * Date: 11/16/17
 * Time: 8:42 AM
 */

class Flatsome_Child_Options {
	/**
	 * The single instance of the class.
	 *
	 * @var Flatsome_Child_Theme_Init
	 */
	protected static $_instance = null;

	public $fonts;

	/**
	 * Flatsome_Child_Options constructor.
	 */
	public function __construct() {

		add_action('init', array($this, 'set_values'));

		// Add settings menu page
		add_action('admin_menu', array($this, 'admin_menu'), 99);
		add_action( 'admin_init', array($this, 'settings_init'));
	}

	public function set_values() {
		$this->fonts = array(
			'iransans' => __('Iran sans', 'flatsome-child'),
			'iransans-farsi-numbers' => __('Iran sans (Persian number)', 'flatsome-child'),
			'iransans-dn' => __('Iran sans Hand writing', 'flatsome-child'),
			'iranyekan' => __('Iran Yekan', 'flatsome-child'),
			'iranyekan-farsi-numbers' => __('Iran Yekan (Persian number)', 'flatsome-child'),
			'iransharp' => __('Iran Sharp', 'flatsome-child'),
			'vazir' => __('Vazir', 'flatsome-child'),
			'sahel' => __('Sahel', 'flatsome-child'),
			'shabnam' => __('Shabnam', 'flatsome-child'),
			'samim' => __('Samim', 'flatsome-child'),
			'gandom' => __('Gandom', 'flatsome-child'),
			'tanha' => __('Tanha', 'flatsome-child'),
			'parastoo' => __('Parastoo', 'flatsome-child'),
			'dirooz' => __('Dirooz', 'flatsome-child'),
		);
	}

	public function admin_menu() {
		add_submenu_page(
			'flatsome-panel',
			__('Persian settings', 'flatsome-child'),
			__('Persian settings', 'flatsome-child'),
			'manage_options',
			'flatsome-persian-settings',
			array($this, 'admin_menu_content')
		);
	}

	public function admin_menu_content() {
		?>
		<div class="wrap">
			<h1><?php _e('Persian settings', 'flatsome-child') ?></h1>
			<?php $active_tab = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'general'; ?>
			<h2 class="nav-tab-wrapper" style="margin-bottom: 10px">
				<a href="<?php echo admin_url('admin.php?page=flatsome-persian-settings&tab=general') ?>" class="nav-tab <?php echo $active_tab == 'general' ? 'nav-tab-active' : ''; ?>"><?php _e('General', 'flatsome-child') ?></a>
			</h2>

			<form method="post" action="options.php">
				<?php
				settings_errors();
				if( $active_tab == 'general' ) {
					settings_fields( 'flatsome-child-group' );
					do_settings_sections( 'flatsome-child-general-page' );
				} elseif( $active_tab == 'notifications' ) {
					settings_fields( 'flatsome-child-group' );
					do_settings_sections( 'zhk_notifications_page' );
				}
				submit_button();
				?>
			</form>
		</div>
		<?php
	}

	public function settings_init(  ) {
		register_setting(
			'flatsome-child-group',
			'flatsome-child-options'
		);

		// Settings Sections
		add_settings_section(
			'typography',
			__('Typography', 'flatsome-child'),
			NULL,
			'flatsome-child-general-page'
		);

		// Settings fields
		add_settings_field(
			'font',
			__('Font', 'flatsome-child'),
			array($this, 'font_callback'),
			'flatsome-child-general-page',
			'typography'
		);
	}

	public function font_callback() {
		?>
		<select name="flatsome-child-options[typography][font]" id="font">
            <option value=""><?php _e('Theme default', 'flatsome-child'); ?></option>
			<?php foreach ($this->fonts as $font_key => $font_title): ?>
				<option value="<?php echo $font_key ?>" <?php selected( self::get_option('font', 'typography'), $font_key ) ?>><?php echo $font_title ?></option>
			<?php endforeach; ?>
		</select>
		<?php
	}

	public static function get_option($option_name = false, $option_group = false)
	{
		$options = get_option('flatsome-child-options');
		$sorted_options = array();


		$sorted_options['typography']['font'] = (isset($options['typography']['font']) && !empty($options['typography']['font'])) ? $options['typography']['font'] : '';

		if( !empty($option_name) && !empty($option_group) ) {
			return $sorted_options[$option_group][$option_name];
		} else {
			return $options;
		}
	}


	/**
	 * Main Class Instance.
	 *
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return Flatsome_Child_Theme_Init - Main instance.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
}