<?php
/**
 * @package Hello_Dolly
 * @version 1.6
 */
/*
Plugin Name: Flatsome Admin translation
Plugin URI: http://wordpress.org/plugins/hello-dolly/
Description: This plugin is written by mojtaba darvishi for translating flatsome admin pages to persian.
Author: Mojtaba Darvishi
Version: 1.0.0
Author URI: http://mojtaba.in
Text Domain: flatsome-admin
Domain Path: /languages/
*/
class Flatsome_Admin_Translation {

	/**
	 * The single instance of the class.
	 *
	 * @var Flatsome_Admin_Translation
	 */
	protected static $_instance = null;

	private $name;

	private $version;

	private $description;

	private $author;

	/**
	 * Flatsome_Admin_Translation constructor.
	 */
	public function __construct() {

		$this->name         = __('Flatsome Admin translation', 'flatsome-admin');
		$this->description  = __('This plugin is written by mojtaba darvishi for translating flatsome admin pages to persian.', 'flatsome-admin');
		$this->author       = __('Mojtaba Darvishi', 'flatsome-admin');

		add_action( 'plugins_loaded', array($this, 'load_text_domain') );


	}
	/**
	 * Load plugin textdomain.
	 *
	 * @since 1.0.0
	 */
	public function load_text_domain(  ) {
		load_plugin_textdomain( 'flatsome-admin', false, basename( dirname( __FILE__ ) ) . '/languages' );
	}

	/**
	 * Main Class Instance.
	 *
	 * Ensures only one instance of this class is loaded or can be loaded.
	 *
	 * @static
	 * @return Flatsome_Admin_Translation - Main instance.
	 */
	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}
}
Flatsome_Admin_Translation::instance();
?>
